// components/printerSetting/printerSetting.js
Component({
  /**
   * 组件的属性列表
   */
  properties: {

  },

  /**
   * 组件的初始数据
   */
  data: {
    labelWidth: 100.0,
    labelHeight: 80.0,
    speedRange: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15],
    speed: 4,
    densityRange: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15],
    density: 7,
    labelTypeRange: [
      { text: "Gap", value: 0 },
      { text: "Back Line", value: 1 },
    ],
    labelType: 0,
    distance: 3.0,
    offset: 0.0,
    directionRange: [
      { text: "Top", value: 0 },
      { text: "Buttom", value: 1 },
    ],
    direction: 0,
    mirrorRange: [
      { text: "Normal", value: 0 },
      { text: "Mirror", value: 1 },
    ],
    mirror: 0,
    actionAfterPrintRange: [
      { text: "Stay", value: 0 },
      { text: "Tear", value: 1 },
      { text: "Peel", value: 2 },
      { text: "Cut", value: 3 },
    ],
    actionAfterPrint: 0,
    feedOffset:0.0,
    cutterModeRange: [
      { text: "反切", value: 0 },
      { text: "正切", value: 1 },
    ],
    cutterMode: 1,
    cutterPiece: 1


  },

  /**
   * 组件的方法列表
   */
  methods: {
    labelWidthChangeHandler(e) {
      this.setData({
        labelWidth: e.detail.value
      });
    },
    labelHeightChangeHandler(e) {
      this.setData({
        labelHeight: e.detail.value
      })
    },
    speedChangeHandler(e) {
      // e.detail.value 是 picker 的 index 值
      console.log("speed set to ", this.data.speedRange[e.detail.value]);
      this.setData({
        speed: this.data.speedRange[e.detail.value]
      })
    },
    densityChangeHandler(e) {
      console.log("density set to ", this.data.speedRange[e.detail.value]);
      this.setData({
        density: this.data.speedRange[e.detail.value]
      })
    },
    labelTypeChangeHandler(e) {
      console.log(e.detail.value);
      console.log("labelType set to ", this.data.labelTypeRange[e.detail.value].text);
      this.setData({
        labelType: this.data.labelTypeRange[e.detail.value].value
      })
    },
    distanceChangeHandler(e) {
      console.log(e.detail.value);
      this.setData({
        distance: e.detail.value
      });
    },
    offsetChangeHandler(e) {
      console.log(e.detail.value);
      this.setData({
        offset: e.detail.value
      });
    },
    async setPrinterHandler() {

      //parameter
      const width = parseFloat(this.data.labelWidth);
      const height = parseFloat(this.data.labelHeight);
      const speed = this.data.speed;
      const density = this.data.density;
      const sensor = this.data.labelType;
      const vertical = parseFloat(this.data.distance);
      const offset = parseFloat(this.data.offset)

      const sdk = getApp().globalData.sdk;
      let res = await sdk.setup(width, height, speed, density, sensor, vertical, offset);
      console.log('setPrinterHandler res=',res);
    },
    directionChangeHandler(e) {
      console.log(e.detail.value);
      console.log("Direction set to ", this.data.directionRange[e.detail.value].text);
      this.setData({
        direction: this.data.directionRange[e.detail.value].value
      })
    },
    mirrorChangeHandler(e) {
      console.log(e.detail.value);
      console.log("Mirror set to ", this.data.mirrorRange[e.detail.value].text);
      this.setData({
        mirror: this.data.mirrorRange[e.detail.value].value
      })
    },
    async setDirectAndMirrorHandler(){
      // parameter
      const direction = this.data.direction;
      const mirror = this.data.mirror;

      const sdk = getApp().globalData.sdk;
      let res = await sdk.setDirectionAndMirror(direction, mirror)
      console.log('setDirectAndMirrorHandler res=',res);
    },
    actionAfterPrintChangeHandler(e) {
      console.log(e.detail.value);
      console.log("Action set to ", this.data.actionAfterPrintRange[e.detail.value].text);
      this.setData({
        actionAfterPrint: this.data.actionAfterPrintRange[e.detail.value].value
      })
    },
    async setActionHandler() {
      // parameter
      const mode = this.data.actionAfterPrint;

      const sdk = getApp().globalData.sdk;
      let res = await sdk.setAfterPrintAction(mode)
      console.log('setActionHandler res=',res);
    },
    feedOffsetChangeHandler(e){
      this.setData({
        feedOffset: e.detail.value
      })
    },
    async setFeedOffsetHandler(){
      // parameter
      const offset = this.data.feedOffset;

      const sdk = getApp().globalData.sdk;
      let res = await sdk.setOffset(offset)
      console.log('setFeedOffsetHandler res=',res);
    },
    cutterModeChangeHandler(e){
      console.log(e.detail.value);
      console.log("cutterMode set to ", this.data.cutterModeRange[e.detail.value].text);
      this.setData({
        cutterMode: this.data.cutterModeRange[e.detail.value].value
      })
    },
    cutterPieceChangeHandler(e){
      console.log(e.detail.value);
      this.setData({
        cutterPiece: e.detail.value
      });
    },
    async setCutterModeAndPieceHandler(){
      // parameter
      const mode = this.data.cutterMode;
      const piece = parseInt(this.data.cutterPiece);

      const sdk = getApp().globalData.sdk;
      let res = await sdk.setCutMode(mode, piece)
      console.log('setCutterModeAndPieceHandler res=',res);
    }
  



  }
})
